/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.unmounters;

import java.io.IOException;
import net.samuelcampos.usbdrivedetector.USBStorageDevice;
import net.samuelcampos.usbdrivedetector.process.CommandExecutor;
import net.samuelcampos.usbdrivedetector.unmounters.AbstractStorageDeviceUnmounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSXStorageDeviceUnmounter
extends AbstractStorageDeviceUnmounter {
    private static final Logger log = LoggerFactory.getLogger(OSXStorageDeviceUnmounter.class);

    @Override
    public void unmount(USBStorageDevice usbStorageDevice) {
        String unmoundCommand = "diskutil unmountDisk " + usbStorageDevice.getDevice();
        try (CommandExecutor commandExecutor = new CommandExecutor(unmoundCommand);){
            commandExecutor.processOutput(arg_0 -> ((Logger)log).trace(arg_0));
            log.debug("Device successfully unmount: {}", (Object)usbStorageDevice);
        }
        catch (IOException e) {
            log.error("Unable to unmount device: {}", (Object)usbStorageDevice, (Object)e);
        }
    }
}

