/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.usb4java.ConfigDescriptor;
import org.usb4java.DeviceDescriptor;
import org.usb4java.EndpointDescriptor;
import org.usb4java.InterfaceDescriptor;

public final class DescriptorUtils {
    private static final Map<Byte, String> CLASS_NAMES = new HashMap<Byte, String>();

    private DescriptorUtils() {
    }

    public static String getUSBClassName(byte usbClass) {
        String name = CLASS_NAMES.get(usbClass);
        if (name == null) {
            return "Unknown";
        }
        return name;
    }

    public static String decodeBCD(short bcd) {
        return String.format("%x.%02x", (bcd & 0xFF00) >> 8, bcd & 0xFF);
    }

    public static String dump(ByteBuffer bytes) {
        bytes.rewind();
        int columns = 16;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (bytes.hasRemaining()) {
            if (i % 16 != 0) {
                builder.append(' ');
            } else if (i >= 16) {
                builder.append(String.format("%n", new Object[0]));
            }
            builder.append(String.format("%02x", bytes.get()));
            ++i;
        }
        return builder.toString();
    }

    public static String dump(DeviceDescriptor descriptor) {
        return DescriptorUtils.dump(descriptor, null, null, null);
    }

    public static String dump(DeviceDescriptor descriptor, String manufacturer, String product, String serial) {
        return String.format("Device Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  bcdUSB %19s%n  bDeviceClass %13d %s%n  bDeviceSubClass %10d%n  bDeviceProtocol %10d%n  bMaxPacketSize0 %10d%n  idVendor %17s%n  idProduct %16s%n  bcdDevice %16s%n  iManufacturer %12d%s%n  iProduct %17d%s%n  iSerial %18d%s%n  bNumConfigurations %7d%n", descriptor.bLength(), descriptor.bDescriptorType(), DescriptorUtils.decodeBCD(descriptor.bcdUSB()), descriptor.bDeviceClass() & 0xFF, DescriptorUtils.getUSBClassName(descriptor.bDeviceClass()), descriptor.bDeviceSubClass() & 0xFF, descriptor.bDeviceProtocol() & 0xFF, descriptor.bMaxPacketSize0() & 0xFF, String.format("0x%04x", descriptor.idVendor() & 0xFFFF), String.format("0x%04x", descriptor.idProduct() & 0xFFFF), DescriptorUtils.decodeBCD(descriptor.bcdDevice()), descriptor.iManufacturer() & 0xFF, manufacturer == null ? "" : " " + manufacturer, descriptor.iProduct() & 0xFF, product == null ? "" : " " + product, descriptor.iSerialNumber() & 0xFF, serial == null ? "" : " " + serial, descriptor.bNumConfigurations() & 0xFF);
    }

    public static String dump(ConfigDescriptor descriptor) {
        return String.format("Configuration Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  wTotalLength %13d%n  bNumInterfaces %11d%n  bConfigurationValue %6d%n  iConfiguration %11d%n  bmAttributes %13s%n    %s%n%s  bMaxPower %16smA%n", descriptor.bLength(), descriptor.bDescriptorType(), descriptor.wTotalLength() & 0xFFFF, descriptor.bNumInterfaces() & 0xFF, descriptor.bConfigurationValue() & 0xFF, descriptor.iConfiguration() & 0xFF, String.format("0x%02x", descriptor.bmAttributes() & 0xFF), (descriptor.bmAttributes() & 0x40) == 0 ? "(Bus Powered)" : "Self Powered", (descriptor.bmAttributes() & 0x20) == 0 ? "" : String.format("    Remote Wakeup%n", new Object[0]), (descriptor.bMaxPower() & 0xFF) * 2);
    }

    public static String dump(InterfaceDescriptor descriptor) {
        return String.format("Interface Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  bInterfaceNumber %9d%n  bAlternateSetting %8d%n  bNumEndpoints %12d%n  bInterfaceClass %10d %s%n  bInterfaceSubClass %7d%n  bInterfaceProtocol %7d%n  iInterface %15d%n", descriptor.bLength(), descriptor.bDescriptorType(), descriptor.bInterfaceNumber() & 0xFF, descriptor.bAlternateSetting() & 0xFF, descriptor.bNumEndpoints() & 0xFF, descriptor.bInterfaceClass() & 0xFF, DescriptorUtils.getUSBClassName(descriptor.bInterfaceClass()), descriptor.bInterfaceSubClass() & 0xFF, descriptor.bInterfaceProtocol() & 0xFF, descriptor.iInterface() & 0xFF);
    }

    public static String dump(EndpointDescriptor descriptor) {
        return String.format("Endpoint Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  bEndpointAddress %9s  EP %d %s%n  bmAttributes %13d%n    Transfer Type             %s%n    Synch Type                %s%n    Usage Type                %s%n  wMaxPacketSize %11d%n  bInterval %16d%n", descriptor.bLength(), descriptor.bDescriptorType(), String.format("0x%02x", descriptor.bEndpointAddress() & 0xFF), descriptor.bEndpointAddress() & 0xF, DescriptorUtils.getDirectionName(descriptor.bEndpointAddress()), descriptor.bmAttributes() & 0xFF, DescriptorUtils.getTransferTypeName(descriptor.bmAttributes()), DescriptorUtils.getSynchTypeName(descriptor.bmAttributes()), DescriptorUtils.getUsageTypeName(descriptor.bmAttributes()), descriptor.wMaxPacketSize() & 0xFFFF, descriptor.bInterval() & 0xFF);
    }

    public static String getTransferTypeName(byte bmAttributes) {
        switch (bmAttributes & 3) {
            case 0: {
                return "Control";
            }
            case 1: {
                return "Isochronous";
            }
            case 2: {
                return "Bulk";
            }
            case 3: {
                return "Interrupt";
            }
        }
        return "Unknown";
    }

    public static String getSynchTypeName(byte bmAttributes) {
        switch ((bmAttributes & 0xC) >> 2) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Asynchronous";
            }
            case 2: {
                return "Adaptive";
            }
            case 3: {
                return "Synchronous";
            }
        }
        return "Unknown";
    }

    public static String getUsageTypeName(byte bmAttributes) {
        switch ((bmAttributes & 0x30) >> 4) {
            case 0: {
                return "Data";
            }
            case 1: {
                return "Feedback";
            }
            case 2: {
                return "Implicit Feedback Data";
            }
            case 3: {
                return "Reserved";
            }
        }
        return "Unknown";
    }

    public static String getSpeedName(int speed) {
        switch (speed) {
            case 4: {
                return "Super";
            }
            case 2: {
                return "Full";
            }
            case 3: {
                return "High";
            }
            case 1: {
                return "Low";
            }
        }
        return "Unknown";
    }

    public static String getDirectionName(byte bEndpointAddress) {
        return (bEndpointAddress & 0xFFFFFF80) == 0 ? "OUT" : "IN";
    }

    static {
        CLASS_NAMES.put((byte)0, "Per Interface");
        CLASS_NAMES.put((byte)1, "Audio");
        CLASS_NAMES.put((byte)2, "Communications");
        CLASS_NAMES.put((byte)3, "HID");
        CLASS_NAMES.put((byte)5, "Physical");
        CLASS_NAMES.put((byte)6, "Imaging");
        CLASS_NAMES.put((byte)7, "Printer");
        CLASS_NAMES.put((byte)8, "Mass Storage");
        CLASS_NAMES.put((byte)9, "Hub");
        CLASS_NAMES.put((byte)10, "Data");
        CLASS_NAMES.put((byte)11, "Smart Card");
        CLASS_NAMES.put((byte)13, "Content Security");
        CLASS_NAMES.put((byte)14, "Video");
        CLASS_NAMES.put((byte)15, "Personal Healthcare");
        CLASS_NAMES.put((byte)-36, "Diagnostic Device");
        CLASS_NAMES.put((byte)-32, "Wireless");
        CLASS_NAMES.put((byte)-2, "Application");
        CLASS_NAMES.put((byte)-1, "Vendor-specific");
    }
}

