/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;

public abstract class MaxFontSizeFinder {
    public static final MaxFontSizeFinder STYLED_TEXT_MAX_FONT_FINDER = new MaxFontSizeFinder(){
        private final Float ZERO = Float.valueOf(0.0f);

        @Override
        public float findMaxFontSize(AttributedCharacterIterator line, float defaultFontSize) {
            line.setIndex(0);
            Float maxFontSize = this.ZERO;
            int runLimit = 0;
            while (runLimit < line.getEndIndex() && (runLimit = line.getRunLimit(TextAttribute.SIZE)) <= line.getEndIndex()) {
                Float size = (Float)line.getAttribute(TextAttribute.SIZE);
                if (maxFontSize.compareTo(size) < 0) {
                    maxFontSize = size;
                }
                line.setIndex(runLimit);
            }
            return maxFontSize.floatValue();
        }

        @Override
        public int findMaxFontSize(AttributedCharacterIterator line, int defaultFontSize) {
            return (int)this.findMaxFontSize(line, (float)defaultFontSize);
        }
    };
    public static final MaxFontSizeFinder DEFAULT_MAX_FONT_FINDER = new MaxFontSizeFinder(){

        @Override
        public float findMaxFontSize(AttributedCharacterIterator line, float defaultFontSize) {
            return defaultFontSize;
        }

        @Override
        public int findMaxFontSize(AttributedCharacterIterator line, int defaultFontSize) {
            return (int)this.findMaxFontSize(line, (float)defaultFontSize);
        }
    };

    public static MaxFontSizeFinder getInstance(boolean isStyledText) {
        if (isStyledText) {
            return STYLED_TEXT_MAX_FONT_FINDER;
        }
        return DEFAULT_MAX_FONT_FINDER;
    }

    public abstract float findMaxFontSize(AttributedCharacterIterator var1, float var2);

    public abstract int findMaxFontSize(AttributedCharacterIterator var1, int var2);
}

