/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.detectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.samuelcampos.usbdrivedetector.USBStorageDevice;
import net.samuelcampos.usbdrivedetector.detectors.AbstractStorageDeviceDetector;
import net.samuelcampos.usbdrivedetector.detectors.DiskInfo;
import net.samuelcampos.usbdrivedetector.process.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxStorageDeviceDetector
extends AbstractStorageDeviceDetector {
    private static final Logger log = LoggerFactory.getLogger(LinuxStorageDeviceDetector.class);
    private static final String CMD_DF = "df -l";
    private static final Pattern command1Pattern = Pattern.compile("^(\\/[^ ]+)[^%]+%[ ]+(.+)$");
    private static final String CMD_CHECK_USB = "udevadm info -q property -n ";
    private static final String INFO_BUS = "ID_BUS";
    private static final String INFO_USB = "usb";
    private static final String INFO_NAME = "ID_FS_LABEL";
    private static final String INFO_UUID = "ID_FS_UUID";
    private static final String DISK_PREFIX = "/dev/";

    protected LinuxStorageDeviceDetector() {
    }

    private void readDiskInfo(DiskInfo disk) {
        String command = CMD_CHECK_USB + disk.getDevice();
        try (CommandExecutor commandExecutor = new CommandExecutor(command);){
            commandExecutor.processOutput(outputLine -> {
                String[] parts = outputLine.split("=");
                if (parts.length > 1) {
                    switch (parts[0].trim()) {
                        case "ID_BUS": {
                            disk.setUSB(INFO_USB.equals(parts[1].trim()));
                            break;
                        }
                        case "ID_FS_LABEL": {
                            disk.setName(parts[1].trim());
                            break;
                        }
                        case "ID_FS_UUID": {
                            disk.setUuid(parts[1].trim());
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<USBStorageDevice> getStorageDevicesDevices() {
        ArrayList<USBStorageDevice> listDevices = new ArrayList<USBStorageDevice>();
        try (CommandExecutor commandExecutor = new CommandExecutor(CMD_DF);){
            commandExecutor.processOutput(outputLine -> {
                Matcher matcher = command1Pattern.matcher((CharSequence)outputLine);
                if (matcher.matches()) {
                    String device = matcher.group(1);
                    String rootPath = matcher.group(2);
                    if (device.startsWith(DISK_PREFIX)) {
                        DiskInfo disk = new DiskInfo(device);
                        disk.setMountPoint(rootPath);
                        this.readDiskInfo(disk);
                        if (disk.isUSB()) {
                            LinuxStorageDeviceDetector.getUSBDevice(disk.getMountPoint(), disk.getName(), disk.getDevice(), disk.getUuid()).ifPresent(listDevices::add);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return listDevices;
    }
}

