/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastaciocintra.escpos.image;

import com.github.anastaciocintra.escpos.image.Bitonal;
import com.github.anastaciocintra.escpos.image.CoffeeImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

public class EscPosImage {
    protected final CoffeeImage image;
    protected final Bitonal bitonalAlgorithm;
    protected ByteArrayOutputStream baCachedEscPosRaster = new ByteArrayOutputStream();
    protected List<ByteArrayOutputStream> CashedEscPosRasterRows_8 = new ArrayList<ByteArrayOutputStream>();
    protected List<ByteArrayOutputStream> CachedEscPosRasterRows_24 = new ArrayList<ByteArrayOutputStream>();

    public EscPosImage(CoffeeImage image, Bitonal bitonalAlgorithm) {
        this.image = image;
        this.bitonalAlgorithm = bitonalAlgorithm;
    }

    public int getHorizontalBytesOfRaster() {
        return this.image.getWidth() % 8 > 0 ? this.image.getWidth() / 8 + 1 : this.image.getWidth() / 8;
    }

    public int getWidthOfImageInBits() {
        return this.image.getWidth();
    }

    public int getHeightOfImageInBits() {
        return this.image.getHeight();
    }

    public int getRasterSizeInBytes() {
        if (this.baCachedEscPosRaster.size() > 0) {
            return this.baCachedEscPosRaster.size();
        }
        this.baCachedEscPosRaster = this.image2EscPosRaster();
        return this.baCachedEscPosRaster.size();
    }

    public List<ByteArrayOutputStream> getRasterRows(int bitsPerColumn_8_or_24) {
        if (bitsPerColumn_8_or_24 == 8) {
            if (this.CashedEscPosRasterRows_8.size() > 0) {
                return this.CashedEscPosRasterRows_8;
            }
            this.CashedEscPosRasterRows_8 = this.image2Rows(bitsPerColumn_8_or_24);
            return this.CashedEscPosRasterRows_8;
        }
        if (this.CachedEscPosRasterRows_24.size() > 0) {
            return this.CachedEscPosRasterRows_24;
        }
        this.CachedEscPosRasterRows_24 = this.image2Rows(bitsPerColumn_8_or_24);
        return this.CachedEscPosRasterRows_24;
    }

    protected List<ByteArrayOutputStream> image2Rows(int bitsPerColumn_8_or_24) {
        ArrayList<ByteArrayOutputStream> lRasterRows = new ArrayList<ByteArrayOutputStream>();
        ArrayList<CoffeeImage> lRGBImageRows = new ArrayList<CoffeeImage>();
        for (int y = 0; y < this.image.getHeight(); y += bitsPerColumn_8_or_24) {
            int height = bitsPerColumn_8_or_24;
            if (y + height > this.image.getHeight()) {
                height = this.image.getHeight() - y;
            }
            CoffeeImage row = this.image.getSubimage(0, y, this.image.getWidth(), height);
            lRGBImageRows.add(row);
        }
        int heightOffset = 0;
        for (CoffeeImage RGBRow : lRGBImageRows) {
            ByteArrayOutputStream baColumBytes = new ByteArrayOutputStream();
            for (int x = 0; x < RGBRow.getWidth(); ++x) {
                int col = 0;
                int max_y = Integer.min(bitsPerColumn_8_or_24, RGBRow.getHeight());
                int bit = 0;
                int bitsWritten = 0;
                for (int y = 0; y < max_y; ++y) {
                    int val = this.getBitonalVal(x, y + heightOffset);
                    col |= val << 7 - bit;
                    if (++bit != 8) continue;
                    baColumBytes.write(col);
                    bitsWritten += 8;
                    col = 0;
                    bit = 0;
                }
                if (bit <= 0) continue;
                baColumBytes.write(col);
                bitsWritten += 8;
                while (bitsWritten < bitsPerColumn_8_or_24) {
                    baColumBytes.write(0);
                    bitsWritten += 8;
                }
            }
            lRasterRows.add(baColumBytes);
            heightOffset += bitsPerColumn_8_or_24;
        }
        return lRasterRows;
    }

    public ByteArrayOutputStream getRasterBytes() {
        if (this.baCachedEscPosRaster.size() > 0) {
            return this.baCachedEscPosRaster;
        }
        this.baCachedEscPosRaster = this.image2EscPosRaster();
        return this.baCachedEscPosRaster;
    }

    protected int getBitonalVal(int x, int y) {
        return this.bitonalAlgorithm.getBitonalVal(this.image, x, y);
    }

    protected ByteArrayOutputStream image2EscPosRaster() {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        for (int y = 0; y < this.image.getHeight(); ++y) {
            int Byte = 0;
            int bit = 0;
            for (int x = 0; x < this.image.getWidth(); ++x) {
                int val = this.getBitonalVal(x, y);
                Byte |= val << 7 - bit;
                if (++bit != 8) continue;
                byteArray.write(Byte);
                Byte = 0;
                bit = 0;
            }
            if (bit <= 0) continue;
            byteArray.write(Byte);
        }
        return byteArray;
    }
}

