/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

public final class Time {
    private int m_milliseconds;
    private boolean m_infinite;

    private Time(int milliseconds, boolean infinite) {
        this.m_milliseconds = milliseconds;
        this.m_infinite = infinite;
    }

    public static Time seconds(double seconds) {
        return new Time((int)(seconds * 1000.0), false);
    }

    public static Time milliseconds(int milliseconds) {
        return new Time(milliseconds, false);
    }

    public static Time infinite() {
        return new Time(-1, true);
    }

    public Time add(Time time) {
        return new Time(this.m_milliseconds + time.getMilliseconds(), this.m_infinite || time.isInfinite());
    }

    public double getSeconds() {
        if (this.m_infinite) {
            return -1.0;
        }
        return (double)this.m_milliseconds / 1000.0;
    }

    public int getMilliseconds() {
        if (this.m_infinite) {
            return -1;
        }
        return this.m_milliseconds;
    }

    public boolean isInfinite() {
        return this.m_infinite;
    }
}

