/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jasperreports.compilers.ReportClassWhitelist;
import net.sf.jasperreports.compilers.StandardReportClassWhitelist;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.ClassLoaderFilter;
import net.sf.jasperreports.functions.FunctionsBundle;
import net.sf.jasperreports.functions.FunctionsUtil;

public class ReportClassFilter
implements ClassLoaderFilter {
    public static final String PROPERTY_PREFIX_CLASS_FILTER_ENABLED = "net.sf.jasperreports.report.class.filter.enabled";
    public static final String PROPERTY_PREFIX_CLASS_WHITELIST = "net.sf.jasperreports.report.class.whitelist.";
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_NOT_VISIBLE = "compilers.class.not.visible";
    private boolean filterEnabled;
    private List<ReportClassWhitelist> whitelists;
    private Map<String, Boolean> visibilityCache = new ConcurrentHashMap<String, Boolean>();

    private static void addHardcodedWhitelist(StandardReportClassWhitelist whitelist) {
        whitelist.addClass("java.lang.Boolean");
        whitelist.addClass("java.lang.String");
        whitelist.addClass("java.lang.StringBuffer");
        whitelist.addClass("java.lang.StringBuilder");
        whitelist.addClass("java.lang.Character");
        whitelist.addClass("java.lang.Byte");
        whitelist.addClass("java.lang.Short");
        whitelist.addClass("java.lang.Integer");
        whitelist.addClass("java.lang.Long");
        whitelist.addClass("java.lang.Float");
        whitelist.addClass("java.lang.Double");
        whitelist.addClass("java.lang.Math");
    }

    public ReportClassFilter(JasperReportsContext jasperReportsContext) {
        JRPropertiesUtil properties = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.filterEnabled = properties.getBooleanProperty(PROPERTY_PREFIX_CLASS_FILTER_ENABLED);
        if (this.filterEnabled) {
            this.whitelists = new ArrayList<ReportClassWhitelist>();
            StandardReportClassWhitelist whitelist = new StandardReportClassWhitelist();
            ReportClassFilter.addHardcodedWhitelist(whitelist);
            ReportClassFilter.loadPropertiesWhitelist(properties, whitelist);
            ReportClassFilter.loadFunctionsWhitelist(jasperReportsContext, whitelist);
            this.whitelists.add(whitelist);
            List<ReportClassWhitelist> extensionWhitelists = jasperReportsContext.getExtensions(ReportClassWhitelist.class);
            this.whitelists.addAll(extensionWhitelists);
        }
    }

    private static void loadPropertiesWhitelist(JRPropertiesUtil propertiesUtil, StandardReportClassWhitelist whitelist) {
        List<JRPropertiesUtil.PropertySuffix> properties = propertiesUtil.getProperties(PROPERTY_PREFIX_CLASS_WHITELIST);
        for (JRPropertiesUtil.PropertySuffix propertySuffix : properties) {
            String whitelistString = propertySuffix.getValue();
            whitelist.addWhitelist(whitelistString);
        }
    }

    private static void loadFunctionsWhitelist(JasperReportsContext jasperReportsContext, StandardReportClassWhitelist whitelist) {
        FunctionsUtil functionsUtil = FunctionsUtil.getInstance(jasperReportsContext);
        List<FunctionsBundle> functionBundles = functionsUtil.getAllFunctionBundles();
        for (FunctionsBundle functionsBundle : functionBundles) {
            List<Class<?>> functionClasses = functionsBundle.getFunctionClasses();
            for (Class<?> functionClass : functionClasses) {
                whitelist.addClass(functionClass.getName());
            }
        }
    }

    public boolean isFilteringEnabled() {
        return this.filterEnabled;
    }

    @Override
    public void checkClassVisibility(String className) throws JRRuntimeException {
        boolean visible = this.isClassVisible(className);
        if (!visible) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CLASS_NOT_VISIBLE, new Object[]{className});
        }
    }

    public boolean isClassVisible(String className) {
        Boolean visible = this.visibilityCache.get(className);
        if (visible == null) {
            visible = this.visible(className);
            this.visibilityCache.put(className, visible);
        }
        return visible;
    }

    protected boolean visible(String className) {
        boolean visible;
        if (this.filterEnabled) {
            visible = false;
            for (ReportClassWhitelist whitelist : this.whitelists) {
                if (!whitelist.includesClass(className)) continue;
                visible = true;
                break;
            }
        } else {
            visible = true;
        }
        return visible;
    }
}

