/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.parameters;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.parameters.AbstractParametersExporterOutput;

public class ParametersOutputStreamExporterOutput
extends AbstractParametersExporterOutput
implements OutputStreamExporterOutput {
    private OutputStream outputStream;
    private boolean toClose = false;

    public ParametersOutputStreamExporterOutput(JasperReportsContext jasperReportsContext, Map<JRExporterParameter, Object> parameters, JasperPrint jasperPrint) {
        super(jasperReportsContext, parameters, jasperPrint);
        this.outputStream = (OutputStream)parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (this.outputStream == null) {
            File destFile = (File)parameters.get(JRExporterParameter.OUTPUT_FILE);
            if (destFile == null) {
                String fileName = (String)parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                if (fileName != null) {
                    destFile = new File(fileName);
                } else {
                    throw new JRRuntimeException("export.parameters.no.output.specified", (Object[])null);
                }
            }
            try {
                this.outputStream = new FileOutputStream(destFile);
                this.toClose = true;
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() {
        if (this.toClose) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

