/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.WrappingImageDataToGraphics2DRenderer;
import net.sf.jasperreports.renderers.WrappingSvgDataToGraphics2DRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;

public class RenderersCache {
    private final RendererUtil rendererUtil;
    private final Map<String, Renderable> resourceRenderers;
    private final Map<String, Renderable> wrappingDataRenderers;

    public RenderersCache(JasperReportsContext jasperReportsContext) {
        this.rendererUtil = RendererUtil.getInstance(jasperReportsContext);
        this.resourceRenderers = new HashMap<String, Renderable>();
        this.wrappingDataRenderers = new HashMap<String, Renderable>();
    }

    public Renderable getLoadedRenderer(ResourceRenderer resourceRenderer) throws JRException {
        Renderable loadedRenderer;
        String resourceRendererId = resourceRenderer.getId();
        if (this.resourceRenderers.containsKey(resourceRendererId)) {
            loadedRenderer = this.resourceRenderers.get(resourceRendererId);
        } else {
            loadedRenderer = this.rendererUtil.getNonLazyRenderable(resourceRenderer.getResourceLocation(), OnErrorTypeEnum.ERROR);
            this.resourceRenderers.put(resourceRendererId, loadedRenderer);
        }
        return loadedRenderer;
    }

    public DimensionRenderable getDimensionRenderable(Renderable renderer) throws JRException {
        DimensionRenderable dimensionRenderer = renderer instanceof DimensionRenderable ? (DimensionRenderable)((Object)renderer) : (renderer instanceof DataRenderable ? (DimensionRenderable)((Object)this.getWrappingRenderable(renderer.getId(), (DataRenderable)((Object)renderer))) : null);
        return dimensionRenderer;
    }

    public Graphics2DRenderable getGraphics2DRenderable(Renderable renderer) throws JRException {
        Graphics2DRenderable grxRenderer = null;
        if (renderer != null) {
            if (renderer instanceof Graphics2DRenderable) {
                grxRenderer = (Graphics2DRenderable)((Object)renderer);
            } else if (renderer instanceof DataRenderable) {
                grxRenderer = (Graphics2DRenderable)((Object)this.getWrappingRenderable(renderer.getId(), (DataRenderable)((Object)renderer)));
            } else {
                throw new JRException("engine.renderable.must.implement.interface", new Object[]{renderer.getClass().getName(), DataRenderable.class.getName() + " or " + Graphics2DRenderable.class.getName()});
            }
        }
        return grxRenderer;
    }

    public Renderable getWrappingRenderable(String rendererId, DataRenderable dataRenderer) throws JRException {
        Renderable wrappingRenderer = null;
        if (this.wrappingDataRenderers.containsKey(rendererId)) {
            wrappingRenderer = this.wrappingDataRenderers.get(rendererId);
        } else {
            boolean isSvgData = this.rendererUtil.isSvgData(dataRenderer);
            wrappingRenderer = isSvgData ? new WrappingSvgDataToGraphics2DRenderer(dataRenderer) : new WrappingImageDataToGraphics2DRenderer(dataRenderer);
            this.wrappingDataRenderers.put(rendererId, wrappingRenderer);
        }
        return wrappingRenderer;
    }
}

